<?php

namespace Modules\Tax\Taxe;

use Illuminate\Database\Eloquent\Model;

class TaxTypeCode extends Model 
{

    protected $table = 'tax_type_codes';
    public $timestamps = true;

    public function base_value()
    {
        return $this->belongsTo('TaxTypeBaseValue', 'base_value_id', 'id');
    }

    public function tax_class()
    {
        return $this->belongsTo('TaxClass');
    }

    public function tax_sub_classes()
    {
        return $this->belongsTo('TaxSubClass');
    }

    public function tax_regional_area()
    {
        return $this->belongsTo('TaxRegionalArea');
    }

    public function tax_code_rates()
    {
        return $this->hasMany('TaxCodeRate');
    }

}